package com.example.fragmentorientation;

import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowMetrics;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();

        int width, height;

        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.R){
            WindowManager windowManager = (WindowManager) getSystemService(WINDOW_SERVICE);
            WindowMetrics metrics = windowManager.getCurrentWindowMetrics();
            width = metrics.getBounds().width();
            height = metrics.getBounds().height();
        }else{
            Display display = getWindowManager().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            width = size.x;
            height = size.y;
        }

        if(width > height){
            fragmentOne fragmentOne = new fragmentOne();
            fragmentTransaction.replace(android.R.id.content, fragmentOne);
        }else{
            fragmentTwo fragmentTwo = new fragmentTwo();
            fragmentTransaction.replace(android.R.id.content, fragmentTwo);
        }

        //fragmentTransaction.commit();
    }
}